#!/bin/sh

#echo "Content-type: text/html"
#echo

PLCCOMS_CONFIG="/etc/default/plccoms"
MBROWSER_CONFIG="/etc/default/minibrowser"

DATA="`cat | sed s/'\&'/' '/g`"

#echo $DATA

PLCCOMSLOG="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMSLOG | sed s/'^.*='/''/`"
MBROWSERLOG="`echo $DATA | sed s/' '/'\n'/g | grep MBROWSERLOG | sed s/'^.*='/''/`"
REBOOT="`echo $DATA | sed s/' '/'\n'/g | grep REBOOT | sed s/'^.*='/''/`"
CLEARCACHE="`echo $DATA | sed s/' '/'\n'/g | grep CLEARCACHE | sed s/'^.*='/''/`"

if [ -r /etc/default/plccoms ]; then
	. /etc/default/plccoms
fi

TMP_CONFIG=`cat $PLCCOMS_CONFIG`

if [ "$PLCCOMSLOG" = "checked" ]; then
echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	killall PLCComS
    fi
else
echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	killall PLCComS
    fi
fi

if [ -r /etc/default/minibrowser ]; then
	. /etc/default/minibrowser
fi

TMP_CONFIG=`cat $MBROWSER_CONFIG`

if [ "$MBROWSERLOG" = "checked" ]; then
echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	killall MiniBrowser
    fi
else
echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	killall MiniBrowser
    fi
fi

if [ "$CLEARCACHE" = "checked" ]; then
    if [ -d "$CACHE_DIR" ]; then
	rm -rf $CACHE_DIR/*
    fi
fi

if [ "$REBOOT" = "checked" ]; then
    reboot -d 2 &
fi

sh setup_debug.cgi
