#!/bin/sh

HTML_PAGE="/var/www/setup_network.html"

if [ ! "$MINIBROWSER" ]; then
    echo "Content-type: text/html"
    echo
fi

NET_DEVICE="eth0"

NET_CONFIG="/etc/network/interfaces"
DNS_CONFIG="/etc/resolv.conf"

if [ "`cat $NET_CONFIG | grep "iface $NET_DEVICE inet static"`" ]; then
    DHCP_OPTION="<OPTION>no<\/OPTION><OPTION>yes<\/OPTION>"
    DHCP="no"
else
    DHCP_OPTION="<OPTION>yes<\/OPTION><OPTION>no<\/OPTION>"
    DHCP="yes"
fi

if [ "`/sbin/ifconfig $NET_DEVICE | grep UP`" ]; then
    IP_ADDR="`/sbin/ifconfig $NET_DEVICE | sed s/' '/'\n'/g | grep 'addr:' | sed s/'addr:'/''/`"
    MASK_ADDR="`/sbin/ifconfig $NET_DEVICE | sed s/' '/'\n'/g | grep 'Mask:' | sed s/'Mask:'/''/`"
fi

MAC_ADDR="`/sbin/ifconfig $NET_DEVICE | grep 'HWaddr' | sed s/'^.*HWaddr '//`"

if [ "$MAC_ADDR" = "" ]; then
    MAC_ADDR="00:00:00:00:00:00"
fi

GW_ADDR="`/sbin/route -n | grep '^0.0.0.0' | grep $NET_DEVICE | sed s/' '/'\n'/g | sed '1,9d' | head -n 1`"

IP_1="`echo $IP_ADDR | sed s/'\.'/'\n'/g | sed '2,4d'`"
IP_2="`echo $IP_ADDR | sed s/'\.'/'\n'/g | sed '1,1d ; 3,4d'`"
IP_3="`echo $IP_ADDR | sed s/'\.'/'\n'/g | sed '1,2d ; 4,4d'`"
IP_4="`echo $IP_ADDR | sed s/'\.'/'\n'/g | sed '1,3d'`"

MASK_1="`echo $MASK_ADDR | sed s/'\.'/'\n'/g | sed '2,4d'`"
MASK_2="`echo $MASK_ADDR | sed s/'\.'/'\n'/g | sed '1,1d ; 3,4d'`"
MASK_3="`echo $MASK_ADDR | sed s/'\.'/'\n'/g | sed '1,2d ; 4,4d'`"
MASK_4="`echo $MASK_ADDR | sed s/'\.'/'\n'/g | sed '1,3d'`"

GW_1="`echo $GW_ADDR | sed s/'\.'/'\n'/g | sed '2,4d'`"
GW_2="`echo $GW_ADDR | sed s/'\.'/'\n'/g | sed '1,1d ; 3,4d'`"
GW_3="`echo $GW_ADDR | sed s/'\.'/'\n'/g | sed '1,2d ; 4,4d'`"
GW_4="`echo $GW_ADDR | sed s/'\.'/'\n'/g | sed '1,3d'`"

DNS1_1="`cat $DNS_CONFIG | grep nameserver | sed '2,2d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '2,4d'`"
DNS1_2="`cat $DNS_CONFIG | grep nameserver | sed '2,2d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,1d ; 3,4d'`"
DNS1_3="`cat $DNS_CONFIG | grep nameserver | sed '2,2d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,2d ; 4,4d'`"
DNS1_4="`cat $DNS_CONFIG | grep nameserver | sed '2,2d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,3d'`"

DNS2_1="`cat $DNS_CONFIG | grep nameserver | sed '1,1d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '2,4d'`"
DNS2_2="`cat $DNS_CONFIG | grep nameserver | sed '1,1d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,1d ; 3,4d'`"
DNS2_3="`cat $DNS_CONFIG | grep nameserver | sed '1,1d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,2d ; 4,4d'`"
DNS2_4="`cat $DNS_CONFIG | grep nameserver | sed '1,1d' | sed s/'^.* '/''/ | sed s/'\.'/'\n'/g | sed '1,3d'`"

if [ "$MINIBROWSER" ]; then
    echo "DHCP=$DHCP"
    echo "IF=$NET_DEVICE"
    echo "MAC=$MAC_ADDR"
    echo "IP_1=$IP_1"
    echo "IP_2=$IP_2"
    echo "IP_3=$IP_3"
    echo "IP_4=$IP_4"
    echo "MASK_1=$MASK_1"
    echo "MASK_2=$MASK_2"
    echo "MASK_3=$MASK_3"
    echo "MASK_4=$MASK_4"
    echo "GW_1=$GW_1"
    echo "GW_2=$GW_2"
    echo "GW_3=$GW_3"
    echo "GW_4=$GW_4"
    echo "DNS1_1=$DNS1_1"
    echo "DNS1_2=$DNS1_2"
    echo "DNS1_3=$DNS1_3"
    echo "DNS1_4=$DNS1_4"
    echo "DNS2_1=$DNS2_1"
    echo "DNS2_2=$DNS2_2"
    echo "DNS2_3=$DNS2_3"
    echo "DNS2_4=$DNS2_4"
else
    cat $HTML_PAGE | sed s/"cgi-bin\/"/""/g | sed s/'$DHCP_OPTION'/"$DHCP_OPTION"/g \
        	   | sed s/'$IP_1'/"$IP_1"/g | sed s/'$IP_2'/"$IP_2"/g | sed s/'$IP_3'/"$IP_3"/g | sed s/'$IP_4'/"$IP_4"/g \
    		   | sed s/'$MASK_1'/"$MASK_1"/g | sed s/'$MASK_2'/"$MASK_2"/g | sed s/'$MASK_3'/"$MASK_3"/g | sed s/'$MASK_4'/"$MASK_4"/g \
    		   | sed s/'$GW_1'/"$GW_1"/g | sed s/'$GW_2'/"$GW_2"/g | sed s/'$GW_3'/"$GW_3"/g | sed s/'$GW_4'/"$GW_4"/g \
    		   | sed s/'$DNS1_1'/"$DNS1_1"/g | sed s/'$DNS1_2'/"$DNS1_2"/g | sed s/'$DNS1_3'/"$DNS1_3"/g | sed s/'$DNS1_4'/"$DNS1_4"/g \
    		   | sed s/'$DNS2_1'/"$DNS2_1"/g | sed s/'$DNS2_2'/"$DNS2_2"/g | sed s/'$DNS2_3'/"$DNS2_3"/g | sed s/'$DNS2_4'/"$DNS2_4"/g
fi
