#! /bin/sh
#
# /etc/init.d/bootsplash.sh
#
# (C)opyright Tecomat a.s.
#
# 2010/08/27 Hosek Martin <hosek@tecomat.cz>
#

. /etc/default/bootsplash

BOOTSPLASH="/tmp/bootsplash/id-start.jpg"
HALTSPLASH="/tmp/bootsplash/id-halt.jpg"

FIFO="/tmp/bootsplash/.bootsplash"

RUNLEVEL="`runlevel`"

id=`echo $0 | sed s/'-0'/' '/ | awk {'print $2'}`

if [ "$id" == "" ]; then
    id="0";
fi

if [ "$BOOTSPLASH_ENABLE" == "Yes" ]; then
    echo -en '\033[?1c' >/dev/tty0

    if [ ! -p $FIFO ]; then
	mkfifo $FIFO

	if [ -f "$BOOTSPLASH" ]; then
	    /sbin/bootsplash -b 109:399:431:12 -c 250:250:250 -f $FIFO "$BOOTSPLASH" &
	fi
    fi

    case "${RUNLEVEL:2}" in
	"0")
		if [ -f "$HALTSPLASH" ]; then
		    echo "exit" > $FIFO
		    rm $FIFO
		    echo "exit" | /sbin/bootsplash -b 0:0:0:0 -c 0:0:0 -f - "$HALTSPLASH"
    		else
		    reset > /dev/tty0
		    echo -en '\033[?1c' >/dev/tty0
		    echo "The system is halted." > /dev/tty0
		    echo "Press turn off power." > /dev/tty0
    		fi
		;;
	"6")
		reset > /dev/tty0
		echo -en '\033[?1c' >/dev/tty0
    		echo "The system rebooting, please wait..." > /dev/tty0
    		;;
	  *)
		if [ -f "$BOOTSPLASH" ]; then
		    echo "$(($id * 15))" > $FIFO
    		else
    		    echo -n "." > /dev/tty0
		fi
		;;
    esac
fi

exit 0
