#!/bin/sh

echo "Content-type: text/html"
echo

case "$QUERY_STRING" in
    "2c52ea59e936e0e7")
	FILE_NAME="/var/log/syslog"
	;;
    "b5124e9abc99bdcf")
	FILE_NAME="/var/log/update.log"
	;;
    "86936a46850b7a90")
	if [ -r /etc/default/plccoms ]; then
	    . /etc/default/plccoms
	fi
	FILE_NAME="`echo $LOG_FILE`"
	;;
    "d3cb612303a873dd")
	if [ -r /etc/default/minibrowser ]; then
	    . /etc/default/minibrowser
	fi
	FILE_NAME="`echo $LOG_FILE`"
	;;
    *)
	;;
esac

#TITLE_NAME=`echo $FILE_NAME | sed s/'.log.gz'/''/`
TITLE_NAME=`echo $FILE_NAME | sed s/'\.log$'/''/`

echo "<HEAD>"
if [ "$TITLE_NAME" ]; then
    echo "<TITLE>`basename $TITLE_NAME`.log</TITLE>"
fi
echo "</HEAD>"

if [ ! -f "$FILE_NAME" ]; then
    exit 1
fi

if [ "`echo "$FILE_NAME" | grep '.gz'`" ]; then
    gzip -c "$FILE_NAME" | sed s/'^'/'<A>'/g | sed s/'$'/'<\/A><BR>'/g
else
    cat "$FILE_NAME" | sed s/'^'/'<A>'/g | sed s/'$'/'<\/A><BR>'/g
fi

exit 0
