#!/bin/sh

HTML_PAGE="../setup_debug.html"

#echo "Content-type: text/html"
#echo

PLCCOMS_CONFIG="/etc/default/plccoms"
MBROWSER_CONFIG="/etc/default/minibrowser"

if [ "$MINIBROWSER" ]; then
    CONTENT_LENGTH=1
fi

if [ $CONTENT_LENGTH != 0 ]; then
    DATA="`cat | sed s/'\&'/' '/g`"
fi

#echo $DATA

PLCCOMSLOG="`echo $DATA | sed s/' '/'\n'/g | grep PLCCOMSLOG | sed s/'^.*='/''/`"
MBROWSERLOG="`echo $DATA | sed s/' '/'\n'/g | grep MBROWSERLOG | sed s/'^.*='/''/`"
REBOOT="`echo $DATA | sed s/' '/'\n'/g | grep REBOOT | sed s/'^.*='/''/`"
CLEARCACHE="`echo $DATA | sed s/' '/'\n'/g | grep CLEARCACHE | sed s/'^.*='/''/`"

if [ -r /etc/default/plccoms ]; then
	. /etc/default/plccoms
fi

TMP_CONFIG=`cat $PLCCOMS_CONFIG`

if [ "$PLCCOMSLOG" = "checked" ]; then
#echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	/sbin/killall PLCComS
    fi
else
#echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $PLCCOMS_CONFIG

	/sbin/killall PLCComS
    fi
fi

if [ -r /etc/default/minibrowser ]; then
	. /etc/default/minibrowser
fi

TMP_CONFIG=`cat $MBROWSER_CONFIG`

if [ "$MBROWSERLOG" = "checked" ]; then
#echo "<P>CHECKED</P>"
    if [ "$DEBUG" != yes ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=yes'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	/sbin/killall MiniBrowser
    fi
else
#echo "<P>NOT CHECKED</P>"
    if [ "$DEBUG" != no ]; then
	TMP_CONFIG=`echo "$TMP_CONFIG" | sed s/'^DEBUG=.*'/'DEBUG=no'/`

	echo "$TMP_CONFIG" > $MBROWSER_CONFIG

	/sbin/killall MiniBrowser
    fi
fi

if [ "$CLEARCACHE" = "checked" ]; then
    if [ -d "$CACHE_DIR" ]; then
	rm -rf $CACHE_DIR/*
	/sbin/killall PLCComS
	/sbin/killall MiniBrowser
    fi
fi

if [ "$REBOOT" = "checked" ]; then
    /sbin/reboot &
fi

sh setup_debug.cgi
